#delimit ;
capture log close;
    
******** Housekeeping stuff;
clear all;
display _n(250);
set matsize 2000; 
 
******** Determines when the program started;
local starttime = "$S_TIME";
  
******** Set this option equal to 1 if you want to save the final file with a time stamp (do this when you produce the final file you send to CMS);
local timestamp = 1;   
  
*******sets up the log for the output;
local a1=substr(c(current_time),1,2);
local a2=substr(c(current_time),4,2);
local a3=substr(c(current_time),7,2);
local b =       c(current_date);
capture log using "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\LDS File Creation\Log\LDS File Creation - CY 2025 Final Rule (`b')`a1'_`a2'_`a3'",  replace t;

******** Set these parameters based on the year of interest;
local year              =  2023;
local rural_adjA_2023   = 0.000;   * This is the CY2022 rural adjustment value for the "High Utilization" counties;
local rural_adjB_2023   = 0.010;   * This is the CY2022 rural adjustment value for the "Low population density" counties;
local rural_adjC_2023   = 0.000;   * This is the CY2022 rural adjustment value for the "All Other" counties;

******** Files that get called up later in the program;
local epioas_file         = "S:\projects\HH-HSPC\HHA-PPS\2_DATA\HHf23_FINAL_2023\ANFILES\hhf23_150_epioas_exclude.dta";
local epioas_dx           = "S:\projects\HH-HSPC\HHA-PPS\2_DATA\HHf23_FINAL_2023\ANFILES\hhf23_150_dx_exclude.dta";
local oasis_file          = "S:\projects\HH-HSPC\HHA-PPS\2_DATA\HHf23_FINAL_2023\ANFILES\hhf23_200_oas_allvars.dta";
local impact_file         = "S:\projects\HH-HSPC\HHA-PPS\2_DATA\HHf23_FINAL_2023\ANFILES\hhf23_743_impact_v11_54_14.dta";
local cost_file           = "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Plotzke\Recalibration (2025 Rule)\Cost Report\Cost Per Visit(21 Jul 2024)11_43_19.dta";    ************* Make sure to add the 1 to the end of the filename;
local pdgm_recal          = "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Plotzke\Recalibration (2025 Rule)\CY2023_Eps_WI(FINAL)-( 3 Aug 2024)17_48_18.dta";
local repricing           = "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Forsstrom\Repricing (2025 Rule)\LDS_30day( 9 Sep 2024)16_46_47.dta";
local pdgmimpact_file2    = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Christian\Home Health Groupings Model\Misc Results\Rulemaking CY2024\Version 2024-09-09\Data\payment (abtscenario10-half).dta";
local rural_file          = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2024 Rule)\Code\Repricing\CY 2019-CY 2022 Rural- Add-On Payment Designations.xls";								
local wageindex_2023_file = "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Plotzke\Recalibration (2025 Rule)\CY 2023 Final HH PPS Wage Index.xlsx";	
local output              = "S:\Projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Plotzke\Recalibration (2025 Rule)\LDS\";
local wageindex           = "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Plotzke\Recalibration (2024 Rule)\CY2023 and CY2024 Home Health Wage Index (FINAL - UPDATED).xlsx"; **** I used the 2023 wage index file here (https://www.cms.gov/files/zip/cy-2023-final-hh-pps-wage-index.zip)and I used the final 2024 wage index file that CHantelle emailed me on 8/21/2023;

/*;
********** Imports a a wage index file that I created.  ;
import excel "`wageindex'", firstrow clear; 
rename   cbsa ben_cbsa;
destring wi*, replace;
tempfile wi_info;
save   "`wi_info'";
*/;



#delimit ;

**********************
**********
********** WAGE INDEX
**********
**********************;
**********************
**********
********** WAGE INDEX
**********
**********************;
**********************
**********
********** WAGE INDEX
**********
**********************;
******** This is the SSA County Code/FIPS code crosswalk - Brian gave this to me back for the 2021 FY rule.  I couldn't find a newer version;
import excel "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Plotzke\Recalibration (2025 Rule)\FY 21 Final Hospice Wage Index(MRP).xlsx", firstrow allstring clear;

**** Cleans up file, only keeps fips and ssa codes;
keep fips ssa;
duplicates drop;
drop if ssa  == "";

**** There are two places - Guam and Virgin Islands - that aren't in the crosswalk - I'm adding them here;
count;
set obs 3274;
count;
replace  ssa = "65000" in 3273;
replace fips = "66000" in 3273;
replace  ssa = "48000" in 3274;
replace fips = "78000" in 3274;

****** Saves a temorary file;
tempfile ssa_xwalk;
save   "`ssa_xwalk'";

********** Loads up the wage index file Chantelle sent over (Aug 15, 2024 - "Wage Index Files") - I made minor changes to the variable names for that file;
import excel "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Plotzke\Recalibration (2025 Rule)\Final_CY2025_HH_wageindex-8-15-24(MRP).xlsx", sheet("Final_CY2025_HH_wageindex") firstrow allstring clear;
destring wi*, replace force;

***** Cleans up file - drops duplicatesa and inserts a fips code for Guam and Virgin islands;
duplicates drop;
replace fips = "66000" if cnty_name == "STATEWIDE" & state == "GU";
replace fips = "78000" if cnty_name == "STATEWIDE" & state == "VI";

***** If a fips county code shows up multiple times, I only keep one - There is an issue with FIPS 09009 - which splits into different CBSAs.  For now, I'm averaging together the two CBSAs ; 
sort fips cbsa*;
by fips: gen count = _n;
tab count;
by fips: egen max_count = max(count);
list if max_count ~= 1;

****** Naugatuck valley (CT) fix (1 FIPS code gets split up);
summ    wi_2025                if fips == "09009";
replace wi_2025    = `r(mean)' if fips == "09009";

summ    wi_2025cap             if fips == "09009";
replace wi_2025cap = `r(mean)' if fips == "09009";


**** This save as a temporary file, the full FIPS/CBSA wage index file;
preserve;

***** Makes sure there is only 1 counter per FIPS;
keep if count == 1;
distinct;

keep fips cbsa_2024 *wi*;
gen cbsa_loc = cbsa_2024;
tempfile wi_file;
save   "`wi_file'";
restore;
drop count max_count;

******** Keeps only those CBSAs that had no changes in counties between the 2018 and 2021 crosswalk and saves those as a seperate temporary files;
******** If possible, we want to merge based on the CBSA on the the claim, but if the CBSA splits into multiple CBSAs (with different wage index values) then we will have to match based on the county code of the beneficiary's address(which might not be where the hospice service took place);
distinct cbsa_2024;
gen     change = 0; 
replace change = 1 if cbsa_2024 ~= cbsa_2025;

by cbsa_2024, sort: egen change_max = max(change);

keep cbsa_2024 change_max *wi*;
count;
keep if change_max == 0;
count;

duplicates drop;
distinct cbsa_2024;
gen cbsa_loc_serv = cbsa_2024;

******** Tempfile;
keep cbsa_2024 *wi*;
rename cbsa_2024 cbsa_loc;
tempfile nochange;
save   "`nochange'";









******** Loads up repricing file;
use "`repricing'", replace;
gen repricing = 1;
tab repricing;
rename lupa        lupa_r;
rename hipps       hipps_r;
rename weight      weight_r;
rename pep         pep_r;
rename outlier     outlier_r;
rename pmt_amt     pmt_amt_r;
rename pmt_amt_out pmt_amt_out_r;

tempfile repricing1;
save   "`repricing1'";


******** This is the wage index from the final rule;
import excel "`wageindex_`year'_file'", sheet("All areas- no counties listed") firstrow clear;
destring wi_`year', replace;
tempfile wage_index;
save   "`wage_index'";


************** Imports information on rural counties from 2019 final rule;
import excel "`rural_file'", sheet("Rural counties") firstrow clear;

*** Creates rural categories;
gen     rural_cat = "";
replace rural_cat = "A" if category == "High Utilization";
replace rural_cat = "B" if category == "Low Population Density";
replace rural_cat = "C" if category == "All Other";

*** Variable housekeeping;
destring fips_cnty, replace;
drop name;

****** There are a few counties that are listed multiple times (with multiple names but the same category) - this deletes those and makes sure fips_cnty cant be used as an identifier;
duplicates drop;
isid fips_cnty;

****** Saves a temp file;
tempfile rural;
save   "`rural'";

********* Load up variables from epioas file;
use "`epioas_file'", replace;
rename srv_cbsa ben_cbsa;
keep ben_cbsa srvc_fipstcnty abt_link bene_id clm_id provider from_dt thru_dt tot_skn_cvis tot_phy_cvis tot_occ_cvis tot_spc_cvis msscvis aidcvis tot_skn_cmin tot_phy_cmin tot_occ_cmin tot_spc_cmin msscmin aidcmin lvisit fvisit occ_dt_50 pep clm_id lupa_add_1st_vis_revonly lupa_add ben_ssastcty; 
*rename hipps_fnl hipps_r;

********* Merges on diagnosis variables;
merge 1:1 abt_link using "`epioas_dx'" , keepusing(icd_dgns_*);
keep if _merge == 1 | _merge == 3;
drop    _merge;
compress;
desc;




**************************************
************
************ Merges on wage index;
************
**************************************;
gen bene_county_saf = ben_ssastcty;
gen cbsa_loc = ben_cbsa;

*******************************;
*****
*****
*****  Merges on the wage index information;
*****
*****
*******************************;


***** There are some hospice claims for Virgin Islands that have a different SSA county code than in the crosswalk, this sets it to the value of the crosswalk.  
***** It doesn't matter that I am setting the value because there is only a single - statewide - WI for the virgin islands;
count;
replace bene_county_saf = "48000" if substr(bene_county_saf,1,2) == "48";
gen ssa = bene_county_saf;

***** Merges on the wage index (using CBSA location) for only those CBSAs that have no change between 2024 and 2025;
merge m:1 cbsa_loc using "`nochange'";
tab _merge;
keep if _merge == 1 | _merge == 3;
gen cbsa_match = _merge == 3;
tab cbsa_match if wi_2024 == .;
count;
drop _merge;
mdesc *;
summ *wi* if cbsa_match == 1;

******* Merges on wage index by the service FIPS county code;
rename srvc_fipstcnty fips;
merge m:1 fips using "`wi_file'", keepusing(*wi*) update;
drop if _merge == 2;
tab _merge;
tab _merge cbsa_match;
mdesc *;
count;
summ *wi*;

gen fips_match = cbsa_match == 0 & _merge == 4;
summ *wi* if cbsa_match == 1;
summ *wi* if fips_match == 1;
tab cbsa_match fips_match;
drop _merge;
drop fips;


***** Merges on the SSA/FIPS crosswalk - I only need this if a claim didn't already merge using the CBSA location  or the service FIPS county code in the previous step;
merge m:1 ssa using  "`ssa_xwalk'";
drop if _merge == 2;
tab _merge cbsa_match;
tab _merge cbsa_match if wi_2024 == .;
count if _merge == 1 & wi_2024 == .;
count;

***** Taking a look at the SSA codes on the claim that didn't merge to the crosswalk (and also didn't merge to a wage index in the previous step);
preserve;
keep if _merge == 1 & wi_2024 == .;
tab ssa, sort;
restore;

drop if _merge == 1 & wi_2024 == .;
tab _merge cbsa_match;
drop    _merge;
count;

***** Merges on the wage index (using the bene's mailing address (county)) for any claims that dont already have a wage index from the previous merge;;
merge m:1 fips using "`wi_file'", keepusing(*wi*) update;
drop if _merge == 2;
tab _merge;
tab _merge cbsa_match;
drop _merge;
mdesc *;
count;
summ *wi*;
*/;

summ *wi* if cbsa_match == 1;
summ *wi* if fips_match == 1;
tab cbsa_match fips_match;







******* If there are any claims with a missing wage index we just apply the average wage index across all claims;
summ  wi*;
mdesc wi*;
forvalues x = 2024/2025 {;
	display "`x'";
	count if wi_`x' == .;
			  
	******* Sets wageindex equal to average wage index if it is missing;
	display "Sets wageindex equal to average wage index if it is missing";
	summ    wi_`x' ;
	replace wi_`x'  = `r(mean)' if wi_`x'  == .;
	summ    wi_`x' ;
};
summ  wi*;
mdesc wi*;




********* Merges on wage index info;
rename   ben_cbsa ben_cbsa_serv ;
destring ben_cbsa_serv, replace;
merge m:1 ben_cbsa_serv using "`wage_index'";
keep if _merge == 1 | _merge == 3;
list ben_cbsa_serv if _merge == 1;
drop    _merge;

rename    ben_cbsa_serv ben_cbsa;
/*;
merge m:1 ben_cbsa using "`wi_info'";
keep if          _merge == 1 | _merge == 3;
list ben_cbsa if _merge == 1;
drop             _merge;
*/;
*/;

********* Merges on info for the rural add-on;
gen fips_cnty = fips;
destring fips_cnty, replace;
merge m:1 fips_cnty using "`rural'";
keep if _merge == 1 | _merge == 3;
drop    _merge;
drop fips_cnty;

***** Not every episode merges to a rural category - this sets the variable to none if a episode doesn't merge;
replace rural_cat = "None" if rural_cat == "";

********* Sets up the rural add-on variable (what the rural add-on percentage amount is);		
gen     rural_add_on = 0;
replace rural_add_on = `rural_adjA_`year'' if rural_cat=="A";   *High utilization;
replace rural_add_on = `rural_adjB_`year'' if rural_cat=="B";   *Low population density;
replace rural_add_on = `rural_adjC_`year'' if rural_cat=="C";   *All Other; 

********* Merges on resource use;
merge 1:1 abt_link using "`cost_file'", keepusing(res_tot_cpm_nrs *cost_min*);
keep if _merge == 1 | _merge == 3;
drop    _merge;
rename res_tot_cpm_nrs res_tot_updt;

********* Merges on impact file;
merge 1:1 abt_link using "`impact_file'", keepusing(wi_2024 wi_2025);
keep if _merge == 1 | _merge == 3;
drop    _merge;

********* Merges on the PDGM recalibrated variables;
merge 1:1 abt_link using "`pdgm_recal'", keepusing(score_full_2025 level_2025 admin_timing_2025 high_cat_2025 hipps_2025 wgt_2025 threshold_2025 tot_cvis);
keep if _merge == 1 | _merge == 3;
drop    _merge;


***** Renames variables and creates PDGM lupa variable;
rename   score_full_2025 score_full;
rename        level_2025 level;
rename admin_timing_2025 admin_timing;
rename     high_cat_2025 high_cat;
rename        hipps_2025 paygroup;
rename          wgt_2025 weight;
gen pdgm_lupa = tot_cvis < threshold_2025;

********* Merges on T.J.'s impact file    ******************CHECK THIS CAREFULLY EACH YEAR- variable names may change and LUPA payments may or may not be included in totpay_nooutlier!!!!!!!!!!!!!!!!!!!!********************;
merge 1:1 abt_link using "`pdgmimpact_file2'", keepusing(outlier10 totpay_nooutlier10 outpay10 tot_pmt10);
gen impact = _merge == 3;
drop         _merge;
rename outlier10          pdgm_outlier;
rename totpay_nooutlier10 pdgm_payment_noout; 
rename outpay10           pdgm_payment_out;

replace pdgm_payment_noout = tot_pmt10 if pdgm_lupa == 1;
drop tot_pmt10;

summ    *payment*;
tabstat *payment*, stat(sum) format (%19.0fc);


********* Merges on the OASIS;
merge 1:1 abt_link using "`oasis_file'", keepusing(hha_id socdate asmdate asmtype m1021_prmry_dgns_cd m1023_othr_dgns_1_cd m1023_othr_dgns_2_cd m1023_othr_dgns_3_cd m1023_othr_dgns_4_cd m1023_othr_dgns_5_cd 
												   m1330_stas_ulcr_prsnt m1332_num_stas_ulcr m1334_stus_prblm_stas_ulcr m1340_srgcl_wnd_prsnt m1342_stus_prblm_srgcl_wnd
												   m1320 subdate m1030_thh_ent_nutr 
												   m1030_thh_iv_infus m1030_thh_none_abv m1030_thh_par_nutr m1200_vision m1242_pain_freq_actvty_mvmt 
												   m1306_unhld_stg2_prsr_ulcr m1311_stg_2_prsr_ulcrs_a1_num m1311_stg_3_prsr_ulcrs_b1_num 
												   m1311_stg_4_prsr_ulcrs_c1_num m1311_unstg_cvrg_e1_num m1311_unstg_deep_tisue_f1_num 
												   m1311_unstg_prsr_ulcr_d1_num m1322_nbr_pru_stg1 m1324_stg_prbl_pru m1400_when_dyspnic m1610_ur_incont 
												   m1620_bwl_incont m1630_ostomy m1810_cu_dress_upr m1820_cu_dress_low m1830_crnt_bathg m1840_cur_toiltg 
												   m1850_cur_trnsfrng m1860_crnt_ambltn m2001_drug_rgmn_rvw_cd  m2200_thrpy_need_na_num  m2200_thrpy_need_num 
												   version_cd  vcode2  asmt_sys_cd m0110_epsd_timing_cd m1800_cu_grooming m1810_cu_dress_upr m1820_cu_dress_low m1830_crnt_bathg 
												   m1840_cur_toiltg m1850_cur_trnsfrng m1860_crnt_ambltn m1033*  b1000_vsn_cd  j0510_pain_sleep_cd  j0520_pain_thrpy_cd 
												   j0530_pain_day_day_cd k0520a1_prntrl_admsn_cd k0520b1_feed_tube_admsn_cd o0110h1a_iv_mdctn_admsn_cd m2030_crnt_mgmt_injctn_mdctn);
keep if _merge == 1 | _merge == 3;
tab     _merge;
drop    _merge;

********** Creates the M0133 (4 or more) variable;
destring *m1033*, replace force;
egen     m1033_total = rowtotal(m1033_hosp_risk_fall_hstry m1033_hosp_risk_wt_loss m1033_hosp_risk_mltpl_hosp m1033_hosp_risk_mltpl_visit m1033_hosp_risk_mentl_bhvr m1033_hosp_risk_cmplnc m1033_hosp_risk_5_mdctn);
tab      m1033_total;
gen      m1033_total4 = m1033_total >= 4 & m1033_total ~= .;
tab      m1033_total4; 
drop     m1033_total             m1033_hosp_risk_fall_hstry m1033_hosp_risk_wt_loss m1033_hosp_risk_mltpl_hosp m1033_hosp_risk_mltpl_visit m1033_hosp_risk_mentl_bhvr m1033_hosp_risk_cmplnc m1033_hosp_risk_5_mdctn; 


********* Variable housekeeping - renames variables, labels variables, orders variables;
rename from_dt      			from_dt;
rename thru_dt      			thru_dt;
rename score_full   			func_score;
rename level        			func_level;
rename high_cat     			comorbid_adj;
rename pdgm_lupa    			lupa;
rename paygroup     			hipps;
rename weight       			weight;
rename res_tot_updt 			res_tot_cpm_nrs;
rename wi_2023      			wage_index23;
rename wi_2024      			wage_index24;
rename wi_2025      			wage_index25;
rename tot_skn_cvis 			skn_cvis;
rename tot_phy_cvis 			phy_cvis;
rename tot_occ_cvis 			occ_cvis;
rename tot_spc_cvis 			spc_cvis;
rename aidcvis      			aid_cvis;
rename msscvis      			mss_cvis;
rename tot_skn_cmin 			skn_cmin;
rename tot_phy_cmin 			phy_cmin;
rename tot_occ_cmin 			occ_cmin;
rename tot_spc_cmin 			spc_cmin;
rename aidcmin      			aid_cmin;
rename msscmin      			mss_cmin;
rename fvisit       			billable_first;
rename lvisit                   billable_last;
rename lupa_add_1st_vis_revonly first_vis;
rename pdgm_payment_noout 		pmt_amt;
rename pdgm_payment_out   		pmt_amt_out;
rename pdgm_outlier       		outlier;

rename m1021_prmry_dgns_cd   m1021_pri_dgn_i10;
rename m1023_othr_dgns_1_cd  m1023_oth_dgn1_i10; 
rename m1023_othr_dgns_2_cd  m1023_oth_dgn2_i10; 
rename m1023_othr_dgns_3_cd  m1023_oth_dgn3_i10;  
rename m1023_othr_dgns_4_cd  m1023_oth_dgn4_i10;  
rename m1023_othr_dgns_5_cd  m1023_oth_dgn5_i10; 


rename m1330_stas_ulcr_prsnt        m1330;
rename m1332_num_stas_ulcr          m1332;
rename m1334_stus_prblm_stas_ulcr   m1334;
rename m1340_srgcl_wnd_prsnt        m1340;
rename m1342_stus_prblm_srgcl_wnd   m1342;
rename m2030_crnt_mgmt_injctn_mdctn m2030;

********* Merges on repricing file;
merge 1:1 abt_link using "`repricing1'", update;
drop _merge;
replace repricing = 0 if repricing == .;
tab     repricing;

********* Put labels on all variables;
label var bene_id 						"Beneficiary ID";
label var provider 						"Provider number (CCN)";
label var clm_id                        "Claim ID";
label var from_dt 						"Claim from date";
label var thru_dt 						"Claim thru date";
label var wage_index23 					"Wage index that would be applied to the claim (2023)";
label var wage_index24 					"Wage index that would be applied to the claim (2024)";
label var wage_index25 					"Wage index that would be applied to the claim (2025)";
label var skn_cost_min 					"The average cost per minute for skilled nursing services multiplied by minutes of service for the agency providing the home health 30-day period of care";
label var phy_cost_min 					"The average cost per minute for physical therapy services multiplied by minutes of service  for the agency providing the home health 30-day period of care";
label var occ_cost_min 					"The average cost per minute for occupational therapy services multiplied by minutes of service  for the agency providing the home health 30-day period of care";
label var spc_cost_min 					"The average cost per minute for speech therapy services multiplied by minutes of service  for the agency providing the home health 30-day period of care";
label var aid_cost_min 					"The average cost per minute for home health aide services multiplied by minutes of service  for the agency providing the home health 30-day period of care";
label var mss_cost_min 					"The average cost per minute for medical social services multiplied by minutes of service  for the agency providing the home health 30-day period of care";
label var func_score 					"Functional score (Recalibrated)";
label var func_level 					"Functional level (Recalibrated)";
label var admin_timing					"Admission source and timing";
label var comorbid_adj 					"Flag for whether 30-day period receives a comorbidity adjustment [0 = No adjustment, 1 = low comorbidity adjustment, 2 = high comorbidity adjustment]  (Recalibrated)";
label var lupa 							"Flag for whether 30-day period is a LUPA (Recalibrated)";
label var lupa_r						"Flag for whether 30-day period is a LUPA (Repriced)";
label var hipps 						"The HIPPS of the 30-day period (Recalibrated)";
label var hipps_r 						"The HIPPS of the 30-day period (Repriced)";
label var weight 						"PDGM case-mix weight (Recalibrated)";
label var weight_r 						"PDGM case-mix weight (Repriced)";
label var pep 							"Flag for whether the 30-day period is a PEP";
label var pep_r 						"Flag for whether the 30-day period is a PEP (Repriced)";
label var outlier 						"Flag for whether the 30-day period is an outlier (Recalibrated)";
label var outlier_r 					"Flag for whether the 30-day period is an outlier (Repriced)";
label var res_tot_cpm_nrs 				"Resource use (Cost per minute plus NRS)";
label var pmt_amt 						"Simulated 2025 PDGM payment amount (does not include outlier payment) (Recalibrated)";
label var pmt_amt_r 					"Simulated Repriced 2023 PDGM payment amount (does not include outlier payment)";
label var pmt_amt_out 					"Simulated 2025 PDGM outlier payment (does not include 10% outlier cap) (Recalibrated)";
label var pmt_amt_out_r 				"Simulated Repriced 2023 PDGM outlier payment (does not include 10% outlier cap)";
label var impact 						"Flag for whether 30-day period is used in PDGM impact analysis";
label var repricing                  	"Flag for whether 30-day period is used in PDGM permanent adjustment/repricing analysis";
label var skn_cvis 						"Nursing Visits";
label var phy_cvis 						"PT Visits";
label var occ_cvis 						"OT Visits";
label var spc_cvis						"SLP Visits";
label var aid_cvis 						"Aide Visits";
label var mss_cvis 						"MSS Visits";
label var skn_cmin 						"SN Minutes";
label var phy_cmin 						"PT Minutes";
label var occ_cmin 						"OT Minutes";
label var spc_cmin 						"SLP Minutes";
label var aid_cmin 						"Aide Minutes";
label var mss_cmin 						"MSS Minutes";
label var billable_first 				"Date of first billable (covered) visit";
label var billable_last 				"Date of last billable (covered) visit";
label var first_vis                     "Indicator for whether first visit was SKN/PT/SLP/OT (for LUPA add-on)";
label var lupa_add                      "Flag for LUPA add-on payment (Repriced)";
label var rural_cat                     "Rural Category for Rural Add-on Payment";
label var rural_add_on                  "Rural Add-on Percentage";
label var m1800_cu_grooming 			 "M1800: Grooming";
label var m1810_cu_dress_upr 			 "M1810: Current ability to dress upper body";
label var m1820_cu_dress_low 			 "M1820: Current ability to dress lower body";
label var m1830_crnt_bathg 				 "M1830: Bathing";
label var m1840_cur_toiltg 				 "M1840: Toilet transferring";
label var m1850_cur_trnsfrng 			 "M1850: Transferring";
label var m1860_crnt_ambltn 			 "M1860: Ambulation/Locomotion";
label var m1033_total4 					 "M1033: Risk of hospitalization has 4 or more items checked";
label var m1021_pri_dgn_i10 			 "M1021: Primary diagnosis code ICD-10-CM";
label var m1023_oth_dgn1_i10 			 "M1023: Other diagnosis code 1 ICD-10-CM";
label var m1023_oth_dgn2_i10 			 "M1023: Other diagnosis code 2 ICD-10-CM";
label var m1023_oth_dgn3_i10 			 "M1023: Other diagnosis code 3 ICD-10-CM";
label var m1023_oth_dgn4_i10 			 "M1023: Other diagnosis code 4 ICD-10-CM";
label var m1023_oth_dgn5_i10 			 "M1023: Other diagnosis code 5 ICD-10-CM";
label var m1030_thh_ent_nutr 			 "M1030: Therapies the patient receives at home (Enteral nutrition)";
label var m1030_thh_iv_infus 			 "M1030: Therapies the patient receives at home (Intravenous or infusion therapies)";
label var m1030_thh_par_nutr 			 "M1030: Therapies the patient receives at home (Parenteral nutrition)";
label var m1030_thh_none_abv 			 "M030: Therapies the patient receives at home (None of the above)";
label var m1200_vision 					 "The patient's vision status";
label var m1242_pain_freq_actvty_mvmt 	 "Frequency of pain interfering with patient's activity or movement";
label var m1306_unhld_stg2_prsr_ulcr 	 "Flag if the patient has at least one unhealed pressure ulcer at stage II or higher";
label var m1311_stg_2_prsr_ulcrs_a1_num  "The current number of unhealed pressure ulcers at stage II";
label var m1311_stg_3_prsr_ulcrs_b1_num  "The current number of unhealed pressure ulcers at stage III";
label var m1311_stg_4_prsr_ulcrs_c1_num  "The current number of unhealed pressure ulcers at stage IV";
label var m1311_unstg_cvrg_e1_num 		 "The current number of unstageable unhealed pressure ulcers due to coverage of wound bed by slough and/or eschar";
label var m1311_unstg_deep_tisue_f1_num  "The current number of unstageable unhealed pressure ulcers due to deep tissue injury in evolution";
label var m1311_unstg_prsr_ulcr_d1_num 	 "The current number of unstageable unhealed pressure ulcers due to non-removable dressing/device";
label var m1322_nbr_pru_stg1 			 "The current number of stage I pressure ulcers";
label var m1324_stg_prbl_pru 			 "The stage of the most problematic unhealed (observable) pressure ulcer";
label var m1330 						 "Flag for whether the patient has a stasis ulcer";
label var m1332 						 "The current number of (observable) stasis wounds";
label var m1334 						 "The status of the most problematic (observable) stasis ulcer";
label var m1340 						 "Flag for whether the patient has a surgical wound";
label var m1342 					 	 "The status of the most problematic (observable) surgical wound";
label var m1400_when_dyspnic 			 "Flag for when the patient is dyspneic or noticeably short of breath";
label var m1610_ur_incont 				 "Flag for whether the patient has urinary incontinence or urinary catheter presence";
label var m1620_bwl_incont 				 "Frequency of bowel incontinence";
label var m1630_ostomy 					 "Flag for whether the patient has an ostomy for bowel elimination that was related to an inpatient stay or necessitated a change in medical or treatment regimen";
label var m2001_drug_rgmn_rvw_cd 		 "Flag for whether a complete drug regimen review was completed";
label var m2030 						 "Patient's current ability to prepare and tale all prescribed injectable medications reliably and safely";
label var socdate 						 "Start of care date";
label var vcode2 						 "Version completed code indicating the version of OASIS actually completed";
label var version_cd 					 "Layout submitted version code field which contains the version number for the data specifications used for submission";
label var asmt_sys_cd 					 "Assessment system code";
label var occ_dt_50 					 "OASIS assessment date on home health claim";
label var asmdate 						 "The date the assessment was completed";
label var asmtype 						 "The reason the assessment is currently being completed";

label var b1000_vsn_cd  				"Ability to see in adequate light (with glasses or other visual appliances)";
label var j0510_pain_sleep_cd  			"Pain effect on sleep";
label var j0520_pain_thrpy_cd 			"Pain interference with therapy activities";
label var j0530_pain_day_day_cd 		"Pain interference with day-to-day activities";
label var k0520a1_prntrl_admsn_cd 		"Nutritional Approaches - last 7 days - Parenteral/IV feeding";
label var k0520b1_feed_tube_admsn_cd 	"Nutritional Approaches - last 7 days - Feeding tube";
label var o0110h1a_iv_mdctn_admsn_cd	"Special treatment, procedures, and programs - IV medications";


******** Orders variables;
order bene_id clm_id provider from_dt thru_dt wage_index23 wage_index24 wage_index25 skn_cost_min phy_cost_min occ_cost_min spc_cost_min aid_cost_min mss_cost_min func_score func_level admin_timing comorbid_adj lupa lupa_r hipps hipps_r weight weight_r pep pep_r outlier outlier_r
res_tot_cpm_nrs pmt_amt pmt_amt_r pmt_amt_out pmt_amt_out_r impact repricing skn_cvis phy_cvis occ_cvis spc_cvis aid_cvis mss_cvis skn_cmin phy_cmin occ_cmin spc_cmin aid_cmin mss_cmin billable_first billable_last first_vis lupa_add rural_cat rural_add_on m1800_cu_grooming m1810_cu_dress_upr 
m1820_cu_dress_low m1830_crnt_bathg m1840_cur_toiltg m1850_cur_trnsfrng m1860_crnt_ambltn m1033_total4 m1021_pri_dgn_i10 m1023_oth_dgn1_i10 m1023_oth_dgn2_i10 m1023_oth_dgn3_i10 m1023_oth_dgn4_i10 m1023_oth_dgn5_i10 
m1030_thh_ent_nutr m1030_thh_iv_infus m1030_thh_par_nutr m1030_thh_none_abv m1200_vision m1242_pain_freq_actvty_mvmt m1306_unhld_stg2_prsr_ulcr m1311_stg_2_prsr_ulcrs_a1_num m1311_stg_3_prsr_ulcrs_b1_num 
m1311_stg_4_prsr_ulcrs_c1_num m1311_unstg_cvrg_e1_num m1311_unstg_deep_tisue_f1_num m1311_unstg_prsr_ulcr_d1_num m1322_nbr_pru_stg1 m1324_stg_prbl_pru m1330 m1332 m1334 m1340 m1342 m1400_when_dyspnic m1610_ur_incont 
m1620_bwl_incont m1630_ostomy m2001_drug_rgmn_rvw_cd m2030 socdate vcode2 version_cd asmt_sys_cd occ_dt_50 asmdate asmtype icd_dgns_* b1000_vsn_cd  j0510_pain_sleep_cd  j0520_pain_thrpy_cd 
j0530_pain_day_day_cd k0520a1_prntrl_admsn_cd k0520b1_feed_tube_admsn_cd o0110h1a_iv_mdctn_admsn_cd; 


********** Only keeps needed variables (plus abt_link);
keep bene_id clm_id provider from_dt thru_dt wage_index23 wage_index24 wage_index25 skn_cost_min phy_cost_min occ_cost_min spc_cost_min aid_cost_min mss_cost_min func_score func_level admin_timing comorbid_adj lupa lupa_r hipps hipps_r weight weight_r pep pep_r outlier outlier_r
res_tot_cpm_nrs pmt_amt pmt_amt_r pmt_amt_out pmt_amt_out_r impact repricing skn_cvis phy_cvis occ_cvis spc_cvis aid_cvis mss_cvis skn_cmin phy_cmin occ_cmin spc_cmin aid_cmin mss_cmin billable_first billable_last first_vis lupa_add rural_cat rural_add_on m1800_cu_grooming m1810_cu_dress_upr 
m1820_cu_dress_low m1830_crnt_bathg m1840_cur_toiltg m1850_cur_trnsfrng m1860_crnt_ambltn m1033_total4 m1021_pri_dgn_i10 m1023_oth_dgn1_i10 m1023_oth_dgn2_i10 m1023_oth_dgn3_i10 m1023_oth_dgn4_i10 m1023_oth_dgn5_i10 
m1030_thh_ent_nutr m1030_thh_iv_infus m1030_thh_par_nutr m1030_thh_none_abv m1200_vision m1242_pain_freq_actvty_mvmt m1306_unhld_stg2_prsr_ulcr m1311_stg_2_prsr_ulcrs_a1_num m1311_stg_3_prsr_ulcrs_b1_num 
m1311_stg_4_prsr_ulcrs_c1_num m1311_unstg_cvrg_e1_num m1311_unstg_deep_tisue_f1_num m1311_unstg_prsr_ulcr_d1_num m1322_nbr_pru_stg1 m1324_stg_prbl_pru m1330 m1332 m1334 m1340 m1342 m1400_when_dyspnic m1610_ur_incont 
m1620_bwl_incont m1630_ostomy m2001_drug_rgmn_rvw_cd m2030 socdate vcode2 version_cd asmt_sys_cd occ_dt_50 asmdate asmtype icd_dgns_* abt_link b1000_vsn_cd  j0510_pain_sleep_cd  j0520_pain_thrpy_cd 
j0530_pain_day_day_cd k0520a1_prntrl_admsn_cd k0520b1_feed_tube_admsn_cd o0110h1a_iv_mdctn_admsn_cd;


********* Replace missing per minute costs so it is always zero;
local list "skn_cost_min phy_cost_min occ_cost_min spc_cost_min aid_cost_min mss_cost_min";
foreach x of local list {;
	replace `x' = 0 if `x' == .;
	};

****** Saves non-time stamp version and exports sample data;
compress;
sort bene_id thru_dt from_dt provider clm_id;
save               "`output'\LDS File_30day - Final", replace;
export excel using "`output'\LDS File Sample.xlsx" in 1/10000, firstrow(variables) replace;


******* Saves time stamp version;
if `timestamp' == 1 {;
	preserve;
	****** Abt use file (contains data going through 2020 and has abt_link);
	save "`output'\LDS File_30day (Abt) (`b')`a1'_`a2'_`a3'", replace;
	****** File for CMS - drops abt_link;
	drop abt_link;
	save "`output'\LDS File_30day (CMS)(`b')`a1'_`a2'_`a3'", replace;
	desc;
	
	restore;
	};


	
*******************;
*** Diagnostics;
*******************;
		
****** Info on episodes;
summ, sep(0);
mdesc;
distinct;

******** Make sure there is 432 HIPPS;
codebook hipps;

******* Check frequency of functional level, admission source, timing, and comorbidity adjustment;
tab func_level;
tab admin_timing;
tab comorbid;

******* Check PDGM weights - should be close to 1.000000;
summ weight if lupa  == 0;

********* Diagnostic info for PDGM;
preserve;

tab impact;
drop if impact == 0;
tabstat pmt_amt pmt_amt_out, stat(sum) format (%19.0fc);
count;

gen num_eps = 1;

**** Collapses to a provider level file;
collapse (sum) num_eps pmt_amt pmt_amt_out, by(provider);
tabstat                pmt_amt pmt_amt_out, stat(sum) format (%19.0fc);

summ pmt_amt_out;
local a  = `r(sum)';

**** Computes outlier cap;
gen outtest = pmt_amt*(1/9);
replace pmt_amt_out = min(pmt_amt_out,outtest);

summ pmt_amt_out;
local a_cap = `r(sum)';

summ pmt_amt;
local b1     = `r(sum)';

local c     = `a' + `b1';
local c_cap = `a_cap' + `b1';

display "No Behavioral Assumptions!!!!!!!!!!!!!";
display "PDGM Outlier payments (before cap)            : `a'";
display "PDGM Outlier payments (after cap)             : `a_cap'";
display "PDGM payments (no outliers)                   : `b1'";
display "PDGM payments + outlier payments (before cap) : `c'";
display "PDGM payments + outlier payments (after cap)  : `c_cap'";

egen total_pdgm = rowtotal(pmt_amt_out pmt_amt);
sort provider;
list provider num_eps total_pdgm* if _n <= 100, clean noobs;
summ num_eps;
display `r(sum)';
summ total_pdgm;
display `r(sum)';

export excel using "S:\Projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\LDS File Creation\Output\DiagCheck.xls", sheet("PDGM") firstrow(variables) replace;
restore;

******** program ends here;
datasig;
display "Start: `starttime'";
display "End: " "$S_TIME";
log close;